package cn.com.duiba.kjy.api.enums.content;

import java.util.Objects;

/**
 * @author zhanghuifeng
 * date 2019-06-14-14:46
 */
public enum RecommendStateEnum {

    RECOMMEND(1, "推荐"),
    UN_RECOMMEND(0, "不推荐"),
    ;
    private Integer code;

    private String desc;

    RecommendStateEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static RecommendStateEnum getByCode(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (RecommendStateEnum enumVal : RecommendStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)){
            return "";
        }
        for (RecommendStateEnum enumVal : RecommendStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
