package cn.com.duiba.kjy.api.enums.seller;

/**
 * 分销状态
 * @author zhanghuifeng
 * date 2019-06-18-11:01
 */
public enum DistributionFormalStateEnum {
    FORMAL(1, "正式的"),
    TEMPORARY(2, "临时的"),
    ;
    private Integer code;

    private String desc;

    DistributionFormalStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static DistributionFormalStateEnum getByCode(Integer code) {
        for (DistributionFormalStateEnum enumVal : DistributionFormalStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (DistributionFormalStateEnum enumVal : DistributionFormalStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
