package cn.com.duiba.kjy.api.remoteservice.shareEntrance;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.shareEntrance.ShareEntranceDto;

import java.util.List;

/**
 * 功能描述：分享入口配置
 *
 * @Auther: xiaotian
 * @Date: 2020/1/3 13:50
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteShareEntranceService {

    /**
     * 根据内容类型获取配置列表
     * @param contentTypeEnum
     * @return
     */
    List<ShareEntranceDto> getByContentType(Integer contentTypeEnum);


    /**
     * 根据主键Id更新配置
     * @param shareEntranceDto
     * @return
     */
    boolean  update(ShareEntranceDto shareEntranceDto);


    /**
     * 根据Id删除配置
     * @param id
     * @return
     */
    boolean delete(Long id);


    /**
     * 添加配置
     * @param shareEntranceDto
     * @return
     */
    boolean add(ShareEntranceDto shareEntranceDto);


    /**
     * 根据内容类型，对象类型，状态值更新数据库
     * @param contentType
     * @param objectType
     * @param status
     * @return
     */
    boolean switchObjectStatus(Integer contentType,Integer objectType,Integer status);

}
