package cn.com.duiba.kjy.api.remoteservice.marketing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.marketing.SellerMarketingGiftDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.marketing.SellerMarketingGiftSearchParam;

/**
 * @author liuchao1
 * @date 2020/2/24 15:39
 */
@AdvancedFeignClient
public interface RemoteSellerMarketingGiftService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 代理人营销礼物信息集合
     */
    Page<SellerMarketingGiftDto> search(SellerMarketingGiftSearchParam param);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 代理人礼物信息
     */
    SellerMarketingGiftDto findById(Long id);

    /**
     * 新增代理人礼物信息
     * @param dto 代理人礼物信息
     * @return 主键id
     */
    Long save(SellerMarketingGiftDto dto);

    /**
     * 根据id修改代理人礼物信息
     * @param dto 代理人礼物信息
     * @return 是否修改成功
     */
    boolean update(SellerMarketingGiftDto dto);

}
