package cn.com.duiba.kjy.api.enums.greeting;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/3/4 11:16
 */
public enum GreetingCardCreateSourceEnum {

    H5(1, "从h5创建"),

    MP(2, "从小程序创建"),

    ;

    private Integer code;
    private String desc;

    GreetingCardCreateSourceEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, GreetingCardCreateSourceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GreetingCardCreateSourceEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static GreetingCardCreateSourceEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
