/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.dto.singlefestival.FestivalAwardConfigDto;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryUtil.class);
    private static final int START = 1;
    private static final int COUNT_UNLIMIT = -1;

    public static FestivalAwardConfigDto getLottery(List<FestivalAwardConfigDto> awardConfigDtoList, Integer lotteryRange) {
        Long awardId;
        FestivalAwardConfigDto awardConfig2;
        int randomNum = LotteryUtil.getRandomForIntegerBounded(1, lotteryRange);
        int index = 1;
        FestivalAwardConfigDto awardDto = null;
        Map id2LotteryMap = awardConfigDtoList.stream().collect(Collectors.toMap(FestivalAwardConfigDto::getId, Function.identity()));
        for (FestivalAwardConfigDto awardConfig2 : awardConfigDtoList) {
            BigDecimal bd = awardConfig2.getProbability();
            if (randomNum >= (index += (bd = bd.multiply(BigDecimal.valueOf(lotteryRange.intValue()))).intValue())) continue;
            awardConfig2.setRandom(randomNum);
            awardDto = awardConfig2;
            break;
        }
        if (Objects.nonNull(awardDto) && Objects.nonNull(awardConfig2 = (FestivalAwardConfigDto)id2LotteryMap.get(awardId = awardDto.getId()))) {
            if (!Objects.equals(awardConfig2.getAwardCount(), -1) && awardConfig2.getSendedCount() >= awardConfig2.getAwardCount()) {
                log.info("\u968f\u673a\u6570:{},\u5956\u54c1\u6ca1\u4e86:{}", (Object)randomNum, (Object)awardConfig2.getAwardName());
                return null;
            }
            return awardDto;
        }
        return null;
    }

    public static int getRandomForIntegerBounded(int min, int max) {
        return new RandomDataGenerator().nextInt(min, max);
    }
}

