package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.enums.ContentPubliclyEnum;
import cn.com.duiba.kjy.api.enums.ContentSellerImportEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/2/12.
 */
@Data
@ToString
public class ContentDto implements Serializable {

    private static final long serialVersionUID = 2222674098997801173L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 公司id，0=公共文章
     */
    private Integer companyId;

    /**
     * 标题
     */
    private String title;

    /**
     * 阅读数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long readNum;

    /**
     * 分享数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long sharedNum;

    /**
     * 状态，1=草稿、2=正常
     */
    private Integer status;

    /**
     * 原创
     */
    private String source;

    /**
     * 原文地址
     */
    private String sourceUrl;

    /**
     * 文章图片URL
     */
    private String mainImgUrl;

    /**
     * 内容类型：article=文章
     */
    private String contentType;

    /**
     * 排序：降序
     */
    private Long sort;

    /**
     * 最后操作人
     */
    private String operator;

    /**
     * 文章地址OSS
     */
    private String textUrl;

    /**
     * 发布日期
     */
    private Date dailyReleaseTime;

    /**
     * 阿里云敏感词检测结果
     */
    private String suggestion;

    /**
     * 内容标签
     */
    private String contentTag;

    private String dataTag;

    private String systemDataTag;

    /**
     * 下载数
     * 与ContentStatisticsSimpleDto中重复，暂时保留，需前端介入
     */
    private Long downloadNum;

    private Integer recommend;

	/**
     * 是否是公有的
     * @see ContentPubliclyEnum
     */
    private Integer publicly;

    /**
     * 是否是销售员上传的
     * @see ContentSellerImportEnum
     */
    private Integer sellerImport;

    private Date timeOpening;

    /**
     *
     *首页展示样式，1=左标题，右配图、2=上标题下配图
     */
    private Integer homeShowType;

    /**
     *
     *首页配图，多图“,”隔开
     */
    private String homeImgUrl;

    /**
     * 推送的标题
     */
    private String pushTitle;

    /**
     * 内容素材vip版本
     * @see cn.com.duiba.kjy.api.enums.version.ContentVersionEnum
     */
    protected Integer contentVersion;

    /**
     * 方图，分享时卡片的图
     */
    private String squareImg;

}
