package cn.com.duiba.kjy.api.enums.tag;

/**
 * 标签等级
 *
 * @Author chentiecheng
 * @Date 2020/2/6 3:22 下午
 */
public enum TagLevelEnum {

    FIRST(1, "一级标签"),
    SECOND(2,"二级标签"),

    ;
    private int code;

    private String desc;

    TagLevelEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static TagLevelEnum getByCode(int code) {
        for (TagLevelEnum enumVal : TagLevelEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        for (TagLevelEnum enumVal : TagLevelEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
