package cn.com.duiba.kjy.api.dto.greeting;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人贺卡访问记录表
 * @author 刘超
 * @date 2019/12/18 11:38
 * @version 1.0
 */
@Data
public class VisitorGreetingCardRecordDto implements Serializable {

    private static final long serialVersionUID = 6026691442264812060L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_greeting_card_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 是否感谢：0-未答谢，1-答谢
     */
    private Integer thanks;

    /**
     * 答谢时间
     */
    private Date thanksTime;

    /**
     * 答谢图片
     */
    private String thanksImgUrl;

    /**
     * 领取金额
     */
    private Integer receivedAmount;

    /**
     * 交易订单号
     */
    private String tradeNo;

    /**
     * 领取状态
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingCardRecordReceiveEnum
     */
    private Integer receivedState;

    /**
     * 红包祝福语
     */
    private String redPacketBlessWord;

    private Long redPacketId;

    /**
     * 领取失败原因
     */
    private String failReason;

    /**
     * 访客领取礼物时填写的手机号
     */
    private String phone;

    /**
     * 礼物领取记录id
     */
    private Long giftRecordId;

    /**
     * 是否已通知代理人补货
     * @see cn.com.duiba.kjy.api.enums.greeting.VisitorReplenishStateEnum
     */
    private Integer replenishState;

    /**
     * 错误码
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingRedPacketFailCodeEnum
     */
    private String failCode;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
