package cn.com.duiba.kjy.api.enums.company;

/**
 * 公司等级枚举
 * @author 吴文哲
 * @date 2019-12-28 10:16
 **/
public enum CompanyLevelEnum {

    FILIALE(1, "分公司"),
    HEAD_OFFICE(2, "总公司"),
    ;

    private Integer type;

    private String desc;

    CompanyLevelEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CompanyLevelEnum getByType(Integer type) {
        for (CompanyLevelEnum enumVal : CompanyLevelEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
