package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/23 1:53 PM
 */
public enum  InteractionTemplateTypeEnum {

    VOTE(0, "投票"),
    OPTION(1, "答题"),
    TABLE(2, "表格"),
    ;

    private Integer type;

    private String desc;

    InteractionTemplateTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionTemplateTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTemplateTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionTemplateTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static InteractionTemplateTypeEnum getByInteractionTypeEnum(Byte interactionType) {
        if (interactionType == null) {
            return null;
        }
        if (InteractionTypeEnum.isOption(interactionType)) {
            return OPTION;
        }
        if (InteractionTypeEnum.isVote(interactionType)) {
            return VOTE;
        }
        return null;
    }
}
