package cn.com.duiba.kjy.api.remoteservice.accurateTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateContentDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;
import cn.com.duiba.kjy.api.enums.accurate.AccurateContentTypeEnum;
import cn.com.duiba.kjy.api.params.accurate.AccuratePageBackParam;
import cn.com.duiba.kjy.api.params.accurate.AccuratePageParam;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemAccurateTagService {

    /**
     * 根据标签集合获取存在的标签集合（切换到新的精准素材库 RemoteAccurateContentService）
     * @param tagIds
     * @return
     */
    @Deprecated
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);
	
	/**
     * 根据itemId集合获取（切换到新的精准素材库 RemoteAccurateContentService）
     * @param itemIds
     * @param itemType @see TagItemTypeEnum
     * @return
     */
	@Deprecated
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

    /**
     * 根据标签获取文章列表（切换到新的精准素材库 RemoteAccurateContentService）
     * @param tag
     * @param pageNo
     * @param pageSize
     * @return
     */
    @Deprecated
    List<Long> pageContent(Long tag,Long companyId,Integer pageNo,Integer pageSize);


    /**
     * 根据标签获取文章总数（切换到新的精准素材库 RemoteAccurateContentService）
     * @param tag
     * @return
     */
    @Deprecated
    Long pageContentCount(Long tag,Long companyId);

    /*
     *
     * 根据素材ID获取一级标签ID（兼容新的精准素材库RemoteAccurateContentService））
     *
     * @param contentId
     * @return
     */
    Long  getFristTagId(Long contentId);


    /**
     * 根据标签获取文章列表(根据内容类型)（切换到新的精准素材库 RemoteAccurateContentService）
     * @param accuratePageParam
     * @return
     */
    @Deprecated
    List<Long> pageContentByContentType(AccuratePageParam  accuratePageParam);


    /**
     * 获取文章列表加文章类型列表
     * @param accuratePageParam
     * @return
     */
    List<AccurateContentDto> pageContentAndTypeByContentType(AccuratePageParam  accuratePageParam);



    /**
     * 根据cid获取详情（切换到新的精准素材库 RemoteAccurateContentService）
     * @param cids
     * @return
     */
    @Deprecated
    List<AccurateContentDto> selectByCids(List<Long> cids);


    /**
     * 根据标签获取文章总数
     * @param accuratePageParam
     * @return
     */
    Long pageContentCountByContentType(AccuratePageParam  accuratePageParam);


    /**
     * 根据标签和内容类型获取文章列表(管理端使用)
     * @param accuratePageBackParam
     * @return
     */
    List<AccurateContentDto> pageContentForBack(AccuratePageBackParam accuratePageBackParam);


    /**
     * 根据标签获取文章总数(管理端使用)
     * @param accuratePageBackParam
     * @return
     */
    Long pageContentCountForBack(AccuratePageBackParam  accuratePageBackParam);

    /**
     * 通过contentId删除精准素材
     * @param cid
     * @return
     */
    boolean  delByContent(Long cid);

    /**
     * 更新排序
     * @param sourceId  移动的contentId
     * @param targetId  目标位置的contentId
     * @return
     */
    boolean  updateSort(Long sourceId,Long targetId);

    /**
     * 根据内容ID获取的内容类型
     * @param cid
     * @return
     */
    AccurateContentTypeEnum  getAccurateTypeByCid(Long cid);


    /**
     * 根据标签id 找到标签下所有的素材id（兼容新的精准素材库 RemoteAccurateContentService）
     * @param tagId
     * @return
     */
    List<Long> findAllItemsByTagId(Long tagId);

    /**
     *
     * @param cid
     * @param recommendTag
     * @return
     */
    boolean updateRecommendTag(Long cid,String recommendTag);
}
