package cn.com.duiba.kjy.api.remoteservice.enhanced;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.enhanced.EnhancedColumnContentDto;
import cn.com.duiba.kjy.api.params.EnhancedColumnContentParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-16 14:09
 * @descript 个人专栏内容remoteService
 */
@AdvancedFeignClient
public interface RemoteEnhancedColumnContentService {

    /**
     * 保存个人专栏内容
     * @param contentId
     * @return
     */
    boolean saveContent(Long contentId);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    boolean deleteContent(Long id);

    /**
     * 上下移动
     * @param id
     * @param moveType
     * @see cn.com.duiba.kjy.api.enums.MoveTypeEnum
     * @return
     */
    boolean move(Long id, Integer moveType);

    /**
     * 分页查询列表
     * @param param
     * @return
     */
    List<EnhancedColumnContentDto> listContents(EnhancedColumnContentParam param);

    /**
     * 总数查询
     * @param param
     * @return
     */
    int countContents(EnhancedColumnContentParam param);


}
