package cn.com.duiba.kjy.api.remoteservice.sellercard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellercard.SellerCardAppraiseStatisticDto;
import cn.com.duiba.kjy.api.params.sellercard.SellerCardAppraiseStatisticUpdateParam;

/**
 * 客户评价统计 rpc服务接口
 * @author 吴文哲
 * @date 2020-03-17 17:36
 **/
@AdvancedFeignClient
public interface RemoteSellerCardAppraiseStatisticService {

    /**
     * 根据sellerId 查找
     *
     * @param sellerId
     * @return
     */
    SellerCardAppraiseStatisticDto findBySellerId(Long sellerId);



    /**
     * 统计代理人的平均星级
     * @param sellerId
     * @return
     */
    String getAvgStarBySellerId(Long sellerId);
}
