package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 2:57 PM
 */
@Data
public class PrizeDto implements Serializable {

    private static final long serialVersionUID = -7811945349904306701L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 第三方奖项ID
     */
    private Long thirdPrizeId;

    /**
     * 奖品来源:1-兑吧,2-客集集,3-销售员自定义
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeSourceEnum
     */
    private Integer prizeSource;

    /**
     * 奖品类型：1-谢谢参与,2-再来一次,3-销售员定制,4-链接优惠券,5-实物
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeTypeEnum
     */
    private Integer prizeType;
}
