package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.GrabWebDto;
import cn.com.duiba.kjy.api.dto.SimpleDto;
import cn.com.duiba.kjy.api.params.GrabWebParam;

import java.util.List;

/**
 * Created by dugq on 2019-04-12.
 */
@AdvancedFeignClient
public interface RemoteGrabWebService {
    GrabWebDto selectOne(Long id);

    GrabWebDto selectByName(String name);

    /**
     * 根据名字和区域查询
     * @param name
     * @param contentLocation
     * @return
     */
    GrabWebDto selectByNameAndContentLocation(String name, Integer contentLocation);

    List<GrabWebDto> selectList(GrabWebParam param);

    int update(GrabWebDto record);

    Integer selectCount(GrabWebDto pojo);

    Long insert(GrabWebDto pojo);

    Integer delete(Long id);

    Integer atomicIncrease(Long id);

    Integer updateLastGrabFlag(GrabWebDto record);

    List<GrabWebDto> selectAllEnableWebAndPush2MQ();

    /**
     * 查询id和名字
     * @return
     */
    List<SimpleDto> selectAllIdAndName(Integer type);

    /**
     * 根据名字和uniqueId查询账号
     * @param name
     * @param uniqueId
     * @return
     */
    Integer selectByNameAndUniqueId(String name,String uniqueId);

}
