package cn.com.duiba.kjy.api.dto.specialregion;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 特殊区域-内容关联表
 * @author kjj mybatis generator
 * 2020-01-23
 */
@Data
public class SpecialRegionContentDto implements Serializable {
    private static final long serialVersionUID = 15797857670443803L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *文章ID
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *标签ID
     */
    private Long tagId;

    /**
     *
     *特殊区块ID
     * not null default = 1
     */
    private Long specialRegionId;

    /**
     *
     *是否置顶 0：false 1：true
     * not null default = 0  {@link cn.com.duiba.kjy.api.enums.SpecialRegionContentEnum }
     */
    private Byte top;

    /**
     * 内容排序权重 新增时，请先插入记录 ，然后将contentSort 更新为ID。
     */
    private Long contentSort;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}
