package cn.com.duiba.kjy.api.enums.clue;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2019-12-30 16:14
 * @descript 访问推送线索
 */
public enum VisitClueTypeEnum {
    NORMAL_VISIT(0, "普通访问", 0),
    FREQUENTLY_VISIT(1, "连续访问", 100),
    DEPT_VISIT(2, "深度访问", 200),
    MATERIAL_VISIT(3, "提交资料的访问", 300),
    SALE_VISIT(4, "销售机会访问", 400),
    VOTE_VISIT(5, "投票访问", 500),
    ANSWER_VISIT(6, "答题访问", 600),
    LOTTERY_VISIT(7, "中奖访问", 700),
    PRODUCT_VISIT(8, "产品素材访问", 800),
    MONTH_ACCUMULATE_VISIT(9, "1个月内累计有效阅读3个保险类素材", 900),
    PRIVATE_FAQ_VISIT(10, "保险理念类FAQ", 1000),
    CLUE_ACTIVITY_SUBMIT_MATERIAL(11, "线索类小游戏", 1100),
    REMARK_NAME_EDIT(12, "新客户备注名修改", 1200),
    LOOK_OVER_COMPANY_INFO(13, "查看公司信息", 1300),
    ASK_EMPLOY_INFO(14, "询问招聘类信息", 1400),
    REVENUE_TALK_MATERIAL(15, "创说会留资", 1500),
    RECRUIT_FAQ_VISIT(16, "增员专题类FAQ", 1350),
    ;

    private Integer code;
    private String description;
    /**
     * 谁看过我展示优先级
     */
    private Integer order;

    VisitClueTypeEnum(Integer code, String description, Integer order) {
        this.code = code;
        this.description = description;
        this.order = order;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public Integer getOrder() {
        return order;
    }

    /**
     * 根据代码返回线索访问类型枚举类
     *
     * @param code
     * @return
     */
    public static VisitClueTypeEnum getByCode(Integer code) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (Objects.equals(visitClueTypeEnum.getCode(), code)) {
                return visitClueTypeEnum;
            }
        }
        return NORMAL_VISIT;
    }

    /**
     * 是否为延迟推送
     * @param code
     * @return
     */
    public static boolean isDelayPush(Integer code) {
        return Objects.equals(NORMAL_VISIT.code, code) || Objects.equals(FREQUENTLY_VISIT.code, code)
                || Objects.equals(DEPT_VISIT.code, code) || Objects.equals(PRODUCT_VISIT.code, code)
                || Objects.equals(MONTH_ACCUMULATE_VISIT.code, code);

    }

    /**
     * 根据线索code获取排序优先级
     * @param code
     * @return
     */
    public static Integer getOrder(Integer code) {
        for (VisitClueTypeEnum visitClueTypeEnum : VisitClueTypeEnum.values()) {
            if (Objects.equals(visitClueTypeEnum.code, code)) {
                return visitClueTypeEnum.order;
            }
        }
        return 0;
    }

}
