package cn.com.duiba.kjy.api.enums.seller;

/**
 * 返现套餐类型
 * @author zhanghuifeng
 * date 2019-06-18-17:59
 */
public enum PromotionComboTypeEnum {

    ONE_YEAR(1, "一年会员"),
    HALF_YEAR(2, "半年会员"),
    ;
    private Integer code;

    private String desc;

    PromotionComboTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static PromotionComboTypeEnum getByCode(Integer code) {
        for (PromotionComboTypeEnum enumVal : PromotionComboTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (PromotionComboTypeEnum enumVal : PromotionComboTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
