package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentExtDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentListDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentListForDeskDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentSimpleDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialTagDetailDto;
import cn.com.duiba.kjy.api.dto.materialContent.MaterialContentHistoryDto;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialContentListForChannelParam;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialContentListForDeskParam;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialContentListParam;

import java.util.Date;
import java.util.List;

/**
 * 发圈素材
 *
 * @Author chentiecheng
 * @Date 2020/3/9 3:45 下午
 */
@AdvancedFeignClient
public interface RemoteMaterialContentService {
    /**
     * 获取发圈素材列表
     * @param param
     * @return
     */
    List<MaterialContentListDto> selectList(MaterialContentListParam param);

    /**
     * 统计发圈素材总数
     * @param param
     * @return
     */
    Long countList(MaterialContentListParam param);

    /**
     * 新增编辑发圈素材
     * @param dto
     * @return
     */
    Boolean insertOrUpdateMaterialContent(MaterialContentExtDto dto);

    /**
     * 根据主键id查详情
     * @param id
     * @return
     */
    MaterialContentExtDto getInfoById(Long id);


    /**
     * 根据内容查详情
     * @param contentId
     * @return
     */
    MaterialContentExtDto getInfoByContentId(Long contentId);


    /**
     * 置顶/取消置顶文章
     * @return
     */
    Boolean topContent(Long id,Integer top);


    /**
     * 发圈素材发布，定时发布，撤销操作
     * @return
     */
    Boolean releaseContentOrCancel(Long id, Integer status, Date releaseTime);

    /**
     * 发圈素材批量发布，定时发布
     * @return
     */
    Boolean batchReleaseContent(List<Long> ids,Date releaseTime);


    /**
     * 根据时间统计最新发布的文章数量
     * startTime 必填  materialTag选填，不填则是查全部
     * @param startTime
     * @return
     */
    Long countByReleaseTime(Date startTime,Long materialTag,Integer version);


    /**
     * 筛选出三天之内的有的推荐的文章（除去置顶）
     * 发布时间，状态，推荐优先级
     * @return
     */
    List<MaterialContentSimpleDto> queryListForDesk(MaterialContentListForDeskParam materialContentListForDeskParam);

    /**
     * 筛选出子频道列表
     * 发布时间，状态，推荐优先级
     * @return
     */
    List<MaterialContentListForDeskDto> queryListForChannel(MaterialContentListForChannelParam materialContentListForChannelParam);

    /**
     * 推荐列表三天之内的文章推荐完，再次展示5天之前的文章
     * 发布时间，状态，推荐优先级
     * @return
     */
    @Deprecated
    List<MaterialContentListForDeskDto> queryListAfterRecommend(Long contentId,Integer pageSize);

    /**
     * 推荐列表三天之内的文章推荐完，根据版本再次展示5天之前的文章
     * 发布时间，状态，推荐优先级
     * @return
     */
    List<MaterialContentListForDeskDto> queryListAfterRecommendByVersion(Long contentId,Integer pageSize,Integer version);

    /**
     * 根据文章Id获取发圈素材详情
     * @param contentIds
     * @return
     */
    List<MaterialContentListForDeskDto> queryListByContentIds(List<Long> contentIds);

    /**
     * 获取今日置顶的文章列表
     * @return
     */
    List<MaterialContentSimpleDto> todayTopList();


    /**
     * 获取今日转发最多的文章列表
     * @return
     */
    List<MaterialContentSimpleDto> todayShareNumList();

    /**
     * 根据用户Id和开始时间点，获取用户最近几天的浏览历史记录
     * @param sellerId
     * @param date
     * @return
     */
    List<MaterialContentHistoryDto>  getHistoryAfterDate(Long sellerId, Date date);


    /**
     * 获取用户今日的发圈素材浏览记录
     * @param sellerId
     * @return
     */
    MaterialContentHistoryDto  getHistoryByCurDate(Long sellerId,Date curDate);


    /**
     * 根据主键Id更新用户最新的浏览记录
     * @param materialContentHistoryDto
     * @return
     */
    boolean insertOrUpdate(MaterialContentHistoryDto materialContentHistoryDto);
    /**
     * 根据id删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 获取标签下的今日发布总数和累计总数和累计转发次数
     * @param tagId
     * @return
     */
    MaterialTagDetailDto  getTagStasticsDetail(Long tagId,Integer version);

    /**
     * 保存小程序二维码
     * @param contentId
     * @param qrUrl
     * @return
     */
    boolean  updateQr(Long contentId,String qrUrl);


    /**
     * 获取小程序二维码
     * @param contentId
     * @return
     */
    String  getQr(Long contentId);

    /**
     * 根据id列表查询有效的id
     * @param ids
     * @return
     */
    List<Long> selectAvailableIdsByIds(List<Long> ids);

    /**
     * 试推发圈素材
     * @param sellerId
     * @param id 日签id
     * @return
     */
    Boolean tryPush(Long sellerId,Long id);
}
