package cn.com.duiba.kjy.api.enums.greeting;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/3/25 19:34
 */
public enum GreetingBannerStateEnum {

    INVALID(0, "已下架"),

    AVAILABLE(1, "已上架"),

    ;

    private Integer code;
    private String desc;

    GreetingBannerStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, GreetingBannerStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GreetingBannerStateEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static GreetingBannerStateEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
