package cn.com.duiba.kjy.api.enums.common;

import java.util.HashMap;
import java.util.Map;

/**
 * 转换类型
 * @author lizhi
 * @date 2020/4/9 1:38 PM
 */
public enum TransTypeEnum {

    MP_PARAM(1, "小程序参数"),
    USER_TRANS(2, "链接转换"),
    ;

    private Integer code;

    private String desc;

    TransTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, TransTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(TransTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static TransTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
