package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.home.RecommendArticleDto;
import cn.com.duiba.kjy.api.dto.home.RecommendArticleListDto;
import cn.com.duiba.kjy.api.params.home.RecommendArticleParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-03-26 16:06
 * @descript 推荐文章列表remoteSerivce
 */
@AdvancedFeignClient
public interface RemoteRecommendArticleService {

    /**
     * 根据主键下架文章
     *
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 新增推荐文章
     *
     * @param recommendArticleDto
     * @return
     */
    boolean save(RecommendArticleDto recommendArticleDto);

    /**
     * 更新推荐文章
     *
     * @param recommendArticleDto
     * @return
     */
    boolean updateById(RecommendArticleDto recommendArticleDto);

    /**
     * 移至
     *
     * @param id
     * @param moveNum
     * @return
     */
    boolean move(Long id, Integer moveNum);

    /**
     * 锁定内容
     *
     * @param id
     * @param lockVal
     * @return
     */
    boolean lock(Long id, Integer lockVal) throws KjyCenterException;

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<RecommendArticleListDto> listByParam(RecommendArticleParam param);

    /**
     * 总数查询
     * @param param
     * @return
     */
    int countByParam(RecommendArticleParam param);

    /**
     * 过滤出推荐的文章id
     * @param contentIds
     * @return
     */
    List<Long> listExistContentId(List<Long> contentIds);

}
