package cn.com.duiba.kjy.api.remoteservice.newyear;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.newyear.NewYearActivityConfigDto;
import cn.com.duiba.kjy.api.dto.newyear.NewYearSellerPhotoDto;
import cn.com.duiba.kjy.api.params.newyear.NewYearSellerPhotoParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-12-11 15:12
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerActivityPhotoService {

    /**
     * 上下移动照片
     * @param photoId
     * @param sellerId
     * @param moveType
     * @return
     */
    Boolean movePhoto(Long photoId, Long sellerId, Integer moveType);

    /**
     * 上传相册
     * @param photoUrls
     * @param sellerId
     * @return
     */
    Integer addPhoto(String photoUrls, Long sellerId);

    /**
     * 查询代理人照片
     * @param photoParam
     * @return
     */
    List<NewYearSellerPhotoDto> listNewYearPhotoDtoByParam(NewYearSellerPhotoParam photoParam);

    /**
     * 删除代理人照片
     * @param photoId
     * @param sellerId
     * @return
     */
    Boolean deletePhoto(Long photoId, Long sellerId);

    /**
     * 点赞
     * @param scid
     * @param likeUserId
     * @param visitTableId
     * @return
     */
    Boolean like(Long scid, Long likeUserId, Long visitTableId);

    /**
     * 查询代理人相册总数
     * @param sellerId
     * @return
     */
    Integer countPhoto(Long sellerId);

    /**
     * 获取活动配置
     * @return
     */
    NewYearActivityConfigDto getConfigDto();

    /**
     * 删除代理人所有的照片
     * @param sellerId
     * @return
     */
    Boolean deleteAllPhotos(Long sellerId);

}
