package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerTeamMemberDataDto;
import cn.com.duiba.kjy.api.dto.seller.SellerTeamPersonStatDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerTeamDateInfoParam;

import java.util.List;

/**
 * 销售团队数据remote
 * @author zhanghuifeng
 * date 2020/3/25-3:32 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamDataService {

    /**
     * 分页查询团队成员数据
     * @param param
     * @return
     */
    Page<SellerTeamPersonStatDto> pageTeamData(SellerTeamDateInfoParam param);

    /**
     * 分页查询团队直属成员数据
     * @param param
     * @return
     */
    List<SellerTeamMemberDataDto> pageTeamMemberData(SellerTeamDateInfoParam param);
}
