package cn.com.duiba.kjy.api.enums.push;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/11/11 9:53 PM
 */
public enum PushCloseTimeTypeEnum {
    START(1, "开始"),
    END(2, "结束"),
    ;

    private Integer type;
    private String desc;

    PushCloseTimeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, PushCloseTimeTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PushCloseTimeTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static PushCloseTimeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
