package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.TodayVisitDto;
import cn.com.duiba.kjy.api.dto.UserVisitedContentDto;
import cn.com.duiba.kjy.api.dto.UsersVisitDto;
import cn.com.duiba.kjy.api.dto.whosawme.UserVisitBo;
import cn.com.duiba.kjy.api.dto.whosawme.UserVisitTimesDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchVisitListParam;
import cn.com.duiba.kjy.api.params.UserVisitContentParam;
import cn.com.duiba.kjy.api.params.UserVisitParam;
import cn.com.duiba.kjy.api.params.VisitLastParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteUserVisitService {

    /**
     * 保存访问记录
     *
     * @param dto
     * @return
     */
    Long save(UsersVisitDto dto);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @deprecated 已废弃 请使用 findLastByScid 接口
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @param type     访问类型
     * @return
     */
    @Deprecated
    UsersVisitDto findLastByParam(Long visitId, Long sellerId, String type);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @return
     */
    Integer countByUserAndSeller(Long visitId, Long sellerId);

    /**
     * 根据用户ID和销售员ID查询最后一条记录
     *
     * @param visitId   用户ID
     * @param sellerId 销售员ID
     * @param scid     销售员内容ID
     * @return
     */
    UsersVisitDto findLastByScid(Long visitId, Long sellerId, Long scid);

    /**
     * 查询文章访问记录列表
     *
     * @param searchVisitListParam
     * @return
     */
    Page<UsersVisitDto> getCustomerVisitList(SearchVisitListParam searchVisitListParam);

    Integer selectVisitCount(SearchVisitListParam param);

    /**
     * 查询用户浏览记录
     *
     * @param param
     * @return
     */
    Page<UserVisitedContentDto> selectUserVisitedContents(UserVisitContentParam param);

    /**
     * 查询单篇文章的访问记录
     *
     * @param param
     * @return
     */
    Page<UsersVisitDto> contentVisitInfo(SearchVisitListParam param);

    /**
     * 查询发布的单篇文章访问总时长
     *
     * @param sellerId 销售id
     * @param scId     销售文章id
     * @return
     */
    Long getTotalReadDuration(Long sellerId, Long scId);

    /**
     * 更新阅读时长
     *
     * @param id
     * @return
     */
    Boolean updateDuration(Long id, Integer duration);

    /**
     * 批量查询每篇文章访问总时长
     *
     * @param scIds
     * @return
     */
    Map<Long, Long> getReadDurationMap(List<Long> scIds);

    /**
     * 批量获取每篇文章访问总人数
     * @param scIds
     * @return
     */
    Map<Long, Integer> getReadNumMap(List<Long> scIds);

    /**
     * 批量修改客户绑定关系
     * @param sellerId
     * @param visitId
     * @return
     */
    Integer updateSellerUserBind(Long sellerId, Long visitId);

    TodayVisitDto countTodayBySeller(UserVisitParam param);

    Boolean markVisitAlready(Long sellerId, Integer type);

    Long countTodayVisitor(String openId);

    Integer countVisitBySeller(Long sellerId);

    /**
     * 根据时间区间获取代理人访问人数
     * @param sellerId
     * @return
     */
    Integer countVisitNumByTime(Long sellerId, Date startDate, Date endDate);

    /**
     * 根据代理人Id和客户userId获取总数
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countNumBySellerIdAndUserId(Long sellerId, Long userId);

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<UsersVisitDto> listByParams(UserVisitParam param);

    /**
     * 根据主键标记已读访问
     * @param id
     * @return
     */
    Integer markAlreadyReadById(Long id);

    /**
     * 获取24小时内代理人击败百分比
     * @param sellId
     * @return
     */
    String getSellerBeatPercentage(Long sellId);


    /**
     * 统计代理人 访客访问次数以及访问内容
     */
    List<UserVisitTimesDto> countVisitTimes(Long sid);

    /**
     * 根据userId 获取当前
     * @param visitId
     * @return
     */
    UsersVisitDto getRecentVisitRecordByUserId(Long visitId);

    /**
     * 根据主键搜索访问记录
     * @param ids
     * @return
     */
    List<UsersVisitDto> listByIds(List<Long> ids);

    /**
     * 根据条件找到最近一条访问记录
     * @param param
     * @return
     */
    UsersVisitDto findLastByCondition(VisitLastParam param);
    /**
     * 列表统计
     * @param param
     * @return
     */
    Integer countByParams(UserVisitParam param);

    /**
     * 统计客户访问次数 及最后访问时间数据
     * @param sellerId
     * @param custUserId
     * @return
     */
    UserVisitBo getCustRecentVisitInfo(Long sellerId, Long custUserId);

    /**
     * 代理人访客对应访问次数Map
     * @param sellerId
     * @return
     */
    Map<Long, Integer> findVisitorId2TimesMap(Long sellerId);

    /**
     * @param depth
     * @return
     */
    Integer updateReadDepth(Long userVisitId, Integer depth);

    /**
     * 根据主键查找单条访问记录
     * @return
     */
    UsersVisitDto findByVisitTableId(Long visitTableId);
	
	/**
     * 根据访问用户ID和创建时间范围查询，访问的不同代理人数(1分钟缓存)
     * @param visitId
     * @param startTime
     * @return
     */
    long findSellerTotalByVisitIdAndTimeWithCache(Long visitId, Date startTime);

    /**
     * 根据sellerId 统计代理人的分享内容的访问次数
     * @param sellerId
     * @return
     */
    Integer countVisitTimesBySeller(Long sellerId);

    /**
     * 更改为已曝光
     * @param visitTableId
     * @return
     */
    Boolean updateIsExposed(Long visitTableId);

    /**
     * 更改代理人客户所有的曝光
     * @param sellerId
     * @param visitorId
     * @return
     */
    Boolean updateExposedBySidAndVid(Long sellerId, Long visitorId);

    /**
     * 更改访问推送类型
     * @param visitTableId
     * @param pushType
     * @return
     */
    Boolean updatePushType(Long visitTableId, Integer pushType);

    /**
     * 根据主键物理删除
     * 代理人演示专用
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据主键查找
     * @param ids
     * @return
     */
    List<UsersVisitDto> findByIds(List<Long> ids);

    /**
     * 代理人来访次数重排序
     * @param sellerId
     * @param visitorId
     * @return
     */
    Integer resortReadNum(Long sellerId,Long visitorId);

}
