package cn.com.duiba.kjy.api.remoteservice.accurateTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateTagCategoryDto;
import cn.com.duiba.kjy.api.dto.accurate.AccurateTagDto;

import java.util.List;

/**
 * 标签上下级所属关系服务
 * @author zhanghuifeng
 * date 2019-04-12-10:15
 */
@AdvancedFeignClient
public interface RemoteAccurateTagCategoryService {

    /**
     * 获取所有信息
     * @return
     */
    List<AccurateTagCategoryDto> findAll();

    /**
     * 根据标签级别查询
     * @param tagLevel
     * @return
     */
    List<AccurateTagDto> findByTagLevel(Integer tagLevel);

    /**
     * 根据标签分类和级别查询
     * @param tagType
     * @return
     */
    List<AccurateTagDto> findByTagTypeAndLevel(String tagType, Integer tagLevel);


}
