package cn.com.duiba.kjy.api.remoteservice.greeting;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.greeting.ContentGreetingCardBannerDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.greeting.GreetingBannerSearchParam;

/**
 * @author liuchao1
 * @date 2020/3/26 10:05
 */
@AdvancedFeignClient
public interface RemoteContentGreetingCardBannerService {

    /**
     * 根据条件查询数据，分页
     * @param param 查询条件
     * @return banner信息
     */
    Page<ContentGreetingCardBannerDto> findPage(GreetingBannerSearchParam param);

    /**
     * 根据主键id查询banner信息
     * @param id 主键id
     * @return banner信息
     */
    ContentGreetingCardBannerDto findById(Long id);

    /**
     * 保存或更新贺卡banner
     * @param dto banner信息
     * @return 主键id
     */
    Long saveOrUpdate(ContentGreetingCardBannerDto dto);

    /**
     * 更新banner信息
     * @param dto banner信息
     * @return 执行结果
     */
    boolean update(ContentGreetingCardBannerDto dto);

    /**
     * 根据主键删除banner信息
     * @param id banner主键
     * @return
     */
    boolean delete(Long id);

    /**
     * 根据条件统计数据
     * @param param 查询条件
     * @return 符合条件的条数
     */
    Integer count(GreetingBannerSearchParam param);
}
