package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 吴文哲
 * @date 2019-08-26 18:56
 **/
public enum InteractionTypeEnum {

    OPTION_SINGLE((byte)0,"问答题单选"),
    OPTION_MULTI((byte)1,"问答题多选"),
    VOTE_PK((byte)2,"投票pk"),
    VOTE_SINGLE((byte)3,"投票单选"),
    VOTE_MULTI((byte)4,"投票多选"),
    ;

    private Byte type;
    private String desc;

    InteractionTypeEnum(Byte type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isOption(Byte type){
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_SINGLE || typeEnum == OPTION_MULTI;
    }

    public static boolean isVote(Byte type){
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == VOTE_PK || typeEnum == VOTE_SINGLE || typeEnum == VOTE_MULTI;
    }

    public static boolean isMultiple(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_MULTI || typeEnum == VOTE_MULTI;
    }

    public static boolean isSingle(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_SINGLE || typeEnum == VOTE_PK || typeEnum == VOTE_SINGLE;
    }

    private static final Map<Byte, InteractionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionTypeEnum getByType(Byte type){
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据模板类型和选项类型，获取互动类型
     * @param typeEnum 模板类型
     * @param selectionTypeEnum 选项类型
     * @return 互动类型
     */
    public static InteractionTypeEnum convert2InteractionTypeEnum(InteractionTemplateTypeEnum typeEnum,
                                                                  InteractionSelectionTypeEnum selectionTypeEnum) {
        if (typeEnum == null) {
            return null;
        }
        if (selectionTypeEnum == null) {
            return null;
        }
        if (typeEnum == InteractionTemplateTypeEnum.VOTE && selectionTypeEnum == InteractionSelectionTypeEnum.SINGLE) {
            return VOTE_SINGLE;
        }
        if (typeEnum == InteractionTemplateTypeEnum.VOTE && selectionTypeEnum == InteractionSelectionTypeEnum.MULTIPLE) {
            return VOTE_MULTI;
        }
        if (typeEnum == InteractionTemplateTypeEnum.OPTION && selectionTypeEnum == InteractionSelectionTypeEnum.SINGLE) {
            return OPTION_SINGLE;
        }
        if (typeEnum == InteractionTemplateTypeEnum.OPTION && selectionTypeEnum == InteractionSelectionTypeEnum.MULTIPLE) {
            return OPTION_MULTI;
        }
        return null;
    }
}
