package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售团队邀请类型枚举
 * @author zhanghuifeng
 * date 2020/3/24-10:42 上午
 */
public enum SellerTeamInviteTypeEnum {

    INVITE_PARENT(1, "邀请上级"),
    INVITE_CHILD(2, "邀请下级"),
    ;

    private Integer code;

    private String desc;

    SellerTeamInviteTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerTeamInviteTypeEnum getByCode(Integer code) {
        for (SellerTeamInviteTypeEnum enumVal : SellerTeamInviteTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerTeamInviteTypeEnum enumVal : SellerTeamInviteTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
