package cn.com.duiba.kjy.api.dto.seller;

import cn.com.duiba.kjy.api.enums.seller.SellerDynamicBizTypeEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerDynamicTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售动态记录Dto
*/
@Data
public class SellerDynamicDto implements Serializable {

    private static final long serialVersionUID = -7341348137515511918L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 销售员ID，对应tb_seller.id
    */
    private Long sellerId;

    /**
    * 业务ID，对应转发记录表、访问记录表和代理人精准素材详情关联表ID
    */
    private Long bizId;

    /**
    * 业务类型：1、转发记录，2、访问记录3销售线索
     * @see SellerDynamicBizTypeEnum
    */
    private Integer bizType;

    /**
    * 动态类型：1、访客2、转发素材3、转发名片4、使用营销工具5、获得销售线索
     * @see SellerDynamicTypeEnum
    */
    private Integer dynamicType;
}

