package cn.com.duiba.kjy.api.enums.home;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-03-31 10:15
 * @descript 推荐文章锁定枚举
 */
public enum RecommendArticleLockEnum {
    NOT_LOCK(0, "不锁定"),
    LOCK(1, "锁定");

    private Integer code;
    private String description;

    RecommendArticleLockEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据code获取枚举
     * @param code
     * @return
     */
    public static RecommendArticleLockEnum getByCode(Integer code) {
        for (RecommendArticleLockEnum recommendArticleLockEnum : RecommendArticleLockEnum.values()) {
            if (Objects.equals(recommendArticleLockEnum.code, code)) {
                return recommendArticleLockEnum;
            }
        }
        return null;
    }
}
