package cn.com.duiba.kjy.api.remoteservice.preInstall;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallBatchDto;
import cn.com.duiba.kjy.api.dto.preInstall.PreInstallSellerDto;
import cn.com.duiba.kjy.api.dto.privatechat.UserFormIdDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.preInstall.ActivateParam;
import cn.com.duiba.kjy.api.params.preInstall.AddBatchParam;
import cn.com.duiba.kjy.api.params.preInstall.LivePageQuery;

/**
 * @auther: xiaotian
 * @date: 2020-04-13 14:17
 * @description: 预设会员remote接口
 */
@AdvancedFeignClient
public interface RemotePreInstallService {

    /**
     * 创建预设会员账号批次
     * @param addBatchParam
     * @return
     */
    Long createBatch(AddBatchParam  addBatchParam);


    /**
     * 获取批次详情
     * @param id
     * @return
     */
    PreInstallBatchDto  getById(Long id);


    /**
     * 管理端筛选列表
     * @param livePageQuery
     * @return
     */
    Page<PreInstallBatchDto> queryPage(LivePageQuery  livePageQuery);


    /**
     *  更新单条批次记录（对应的细化记录也要更改状态）
     * @param batchId
     * @param status
     * @return
     */
    boolean  updateStatus(Long batchId ,Integer status);



    /**
     * 更新二维码
     * @param batchId
     * @param qrCode
     * @return
     */
    boolean  updateQrCode(Long batchId ,String qrCode);


    /**
     * 根据批次ID和手机号获取详情
     * @param batchId
     * @return
     */
    PreInstallSellerDto selectByBatchAndPhone(Long batchId, String phone);


    /**
     *  更新单条细化记录
     * @return
     */
    boolean  update(PreInstallSellerDto preInstallSellerDto);



    /**
     * 身份确认，激活用户
     * @param activateParam
     * @return
     */
    boolean  activate(ActivateParam activateParam);
}
