package cn.com.duiba.kjy.api.enums.wechat;

import org.apache.commons.lang.StringUtils;

/**
 * @author zhanghuifeng
 * @date 2018/5/16上午11:45
 */
public enum EnterprisePayErrCodeEnum {
    NO_AUTH("NO_AUTH","没有该接口权限"),
    AMOUNT_LIMIT("AMOUNT_LIMIT", "金额超限"),
    PARAM_ERROR("PARAM_ERROR", "参数错误"),
    OPENID_ERROR("OPENID_ERROR", "Openid错误"),
    SEND_FAILED("SEND_FAILED", "付款错误"),
    NOTENOUGH("NOTENOUGH", "余额不足"),
    SYSTEMERROR("SYSTEMERROR", "系统繁忙，请稍后再试"),
    NAME_MISMATCH("NAME_MISMATCH", "姓名校验出错"),
    SIGN_ERROR("SIGN_ERROR", "签名错误"),
    XML_ERROR("XML_ERROR", "Post内容出错"),
    FATAL_ERROR("FATAL_ERROR", "两次请求参数不一致"),
    FREQ_LIMIT("FREQ_LIMIT", "超过频率限制，请稍后再试"),
    MONEY_LIMIT("MONEY_LIMIT", "已经达到今日付款总额上限/已达到付款给此用户额度上限"),
    CA_ERROR("CA_ERROR", "商户API证书校验出错"),
    V2_ACCOUNT_SIMPLE_BAN("V2_ACCOUNT_SIMPLE_BAN", "无法给非实名用户付款"),
    PARAM_IS_NOT_UTF8("PARAM_IS_NOT_UTF8", "请求参数中包含非utf8编码字符"),
    SENDNUM_LIMIT("SENDNUM_LIMIT", "该用户今日付款次数超过限制,如有需要请登录微信支付商户平台更改API安全配置");


    private String code;

    private String codeDesc;

    EnterprisePayErrCodeEnum(String code, String codeDesc){
        this.code = code;
        this.codeDesc = codeDesc;
    }

    public static EnterprisePayErrCodeEnum getByCode(String code) {
        for (EnterprisePayErrCodeEnum enumVal : EnterprisePayErrCodeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getCodeDesc() {
        return codeDesc;
    }
}
