/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.crypto.IdConverterLengthEnum;

public class IdConverter {
    private static final int PRE_LENGTH = 3;

    public static String encode(Long id, IdConverterLengthEnum lengthEnum) {
        if (id == null || lengthEnum == null) {
            return null;
        }
        if (id <= 0L) {
            return null;
        }
        String idStr = String.valueOf(id);
        int idLength = idStr.length();
        if (idLength + 3 > lengthEnum.getLength()) {
            return null;
        }
        String pre = IdConverter.getPre(idLength);
        String encodeIdStr = IdConverter.getEncodeIdStr(idStr);
        String replaceStr = IdConverter.getReplaceStr(encodeIdStr, lengthEnum.getLength() - 3 - idLength);
        return lengthEnum.getCode() + Long.parseLong(pre + replaceStr + encodeIdStr);
    }

    public static Long decode(String id) {
        if (id == null || id.trim().length() == 0) {
            return -1L;
        }
        String encodeIdStr = IdConverter.getEncodeIdStrById(id = id.toUpperCase());
        String decodeIdStr = IdConverter.getDecodeIdStr(encodeIdStr);
        if (decodeIdStr == null || decodeIdStr.trim().length() == 0) {
            return -1L;
        }
        try {
            return Long.parseLong(decodeIdStr);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static String getPre(int length) {
        String lengthStr = String.valueOf(length);
        if (lengthStr.length() < 2) {
            return "10" + lengthStr;
        }
        return "1" + lengthStr;
    }

    private static String getReplaceStr(String encodeIdStr, int replaceLength) {
        if (replaceLength <= 0) {
            return "";
        }
        int num = replaceLength - encodeIdStr.length();
        String replaceStr = num < 0 ? encodeIdStr.substring(0, replaceLength) : (num == 0 ? encodeIdStr : IdConverter.getZero(num / 2) + encodeIdStr + IdConverter.getZero(num - num / 2));
        return IdConverter.replace(replaceStr);
    }

    private static String replace(String replaceStr) {
        char[] chars = replaceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i])) + i + 1;
            int pow = num * num;
            int yu = (num + i) % 10;
            if (yu == 0) {
                yu = 10;
            }
            int result = pow % yu;
            chars[i] = (char)(result + 48);
        }
        return new String(chars);
    }

    private static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    private static String getEncodeIdStrById(String s) {
        int codeLength = 3;
        if (s.length() < codeLength + 3) {
            return "";
        }
        IdConverterLengthEnum lengthEnum = IdConverterLengthEnum.getByCode(s.substring(0, codeLength));
        if (lengthEnum == null) {
            return "";
        }
        String substring = s.substring(codeLength + 1, 3 + codeLength);
        int idLength = Integer.parseInt(substring);
        int startIndex = s.length() - idLength;
        if (startIndex < 3) {
            return "";
        }
        return s.substring(startIndex);
    }

    private static String getEncodeIdStr(String idStr) {
        char[] chars = idStr.toCharArray();
        IdConverter.convert(chars);
        IdConverter.exchange(chars);
        return new String(chars);
    }

    private static String getDecodeIdStr(String encodeIdStr) {
        if (encodeIdStr == null || encodeIdStr.trim().length() == 0) {
            return encodeIdStr;
        }
        char[] chars = encodeIdStr.toCharArray();
        IdConverter.decodeExchange(chars);
        IdConverter.decodeConvert(chars);
        return new String(chars);
    }

    private static void decodeExchange(char[] chars) {
        IdConverter.exchange(chars);
    }

    private static void exchange(char[] chars) {
        for (int i = 0; i < chars.length / 2; ++i) {
            int index = i * 2;
            char temp = chars[index];
            chars[index] = chars[index + 1];
            chars[index + 1] = temp;
        }
    }

    private static void decodeConvert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = num >= 7 ? (num -= 7) : (num += 3);
            chars[i] = (char)(num + 48);
        }
    }

    private static void convert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = (num + 7) % 10;
            chars[i] = (char)(num + 48);
        }
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        for (long i = 1L; i < 100000000L; ++i) {
            Long decode = IdConverter.decode(IdConverter.encode(i, IdConverterLengthEnum.LOTTERY_LENGTH));
            if (decode == i) continue;
            System.out.println("error:" + i);
            return;
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

