package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/2/13.
 */
@Data
@ToString
public class UsersVisitDto implements Serializable {

    private static final long serialVersionUID = 3669827594636233251L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 销售员内容ID，对应tb_seller_content.id
     */
    private Long scId;

    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报
     */
    private String contentType;

    /**
     * 销售员和用户是否绑定为客户，1=绑定、0=未绑定
     */
    private Integer sellerUserBind;

    /**
     * 阅读时长，单位：秒
     */
    private Long readDuration;

    /**
     * 阅读深度：百分比
     */
    private Integer readDepth;

    /**
     * 阅读标志：0=未读、1=已读
     */
    private Integer readMark;

    /**
     * 第几次访问，用户id、销售员id
     */
    private Integer readNum;

    /**
     * 访问来源
     */
    private String comefrom;

    /**
     * 是否首次访问，用户推动通知，0=不是、1=是
     * 已废弃，以后请用pushType字段！！！！后续会删除
     */
    @Deprecated
    private Integer firstVisit;

    /**
     * 推送类型：1-实时推送，0-非实时推送
     */
    private Integer pushType;

    /**
     * 访问用户ID，对应tb_users.id
     */
    private Long visitId;

    /**
     * 是否已曝光
     */
    private Integer isExposed;

    /**
     * 访问路径来源
     * @see cn.com.duiba.kjy.api.enums.user.UserVisitPathEnum
     */
    private Integer visitPath;
    /**
     * 产生的线索类型，10进制格式
     */
    private Integer clueSwitch;

}
