package cn.com.duiba.kjy.api.params.layer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴文哲
 * @date 2020-03-26 15:10
 **/
@Data
public class LayerConfigParam implements Serializable {
    private static final long serialVersionUID = 8683735077809048744L;

    /**
     * 配置主键id
     */
    private Long layerConfigId;

    /**
     *
     *生效开始时间
     */
    private Date availableStartTime;

    /**
     *
     *生效结束时间
     */
    private Date availableEndTime;

    /**
     *
     *生效用户版本 0:所有版本 1:通用版 2:保险专业版
     * not null default = 0
     */
    private Integer availableUserVersion;

    /**
     *
     *1:全部，2:VIP 3:非VIP 4:company
     * not null default = 1
     */
    private Integer sellerFilterType;

    /**
     * 公司id集合
     */
    private String companyIds;

    /**
     *
     *弹层主图图片资源路径
     * max length = 200
     * not null default =
     */
    private String layerMainImgUrl;

    /**
     *
     *弹层跳转路径
     * max length = 500
     * not null default =
     */
    private String redirectUrl;

    /**
     * 备注
     */
    private String remark;

    /**
     *
     *展示条件: 1:有效时间内首次访问 2:有效时间内每次访问直到点击
     * not null default = 1
     */
    private Integer displayCondition;

    /**
     *
     *是否启用，1=启用，0=未启用
     * not null default = 0
     */
    private Integer configState;

}
