package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.params.seller.VisitListTypeEnum;
import cn.com.duiba.kjy.api.util.CusActionConvertorUtil;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/2/13.
 */
@Data
@ToString
public class SellerCustomerDto implements Serializable {

    private static final long serialVersionUID = 7546460267095929357L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     *
     *最后访问时间
     */
    private Date lastVisitTime;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 备注名称
     */
    private String remarkName;

    /**
     * 备注名称拼音
     */
    private String remarkNamePinyin;

    /**
     * 备注名称拼音,首字母
     */
    private String remarkNamePinyinFast;

    /**
     * 顾客意向，企业产品ID，多个英文逗号隔开
     */
    private String custTag;

    /**
     * 顾客电话
     */
    private String custPhone;

    /**
     * 顾客：省
     */
    private String custProvince;

    /**
     * 顾客：市
     */
    private String custCity;

    /**
     * 顾客：区
     */
    private String custArea;

    /**
     * 顾客：备注
     */
    private String custRemark;

    /**
     * 顾客标志
     */
    private Integer custMark;

    /**
     * 是否与代理人有一级接触
     */
    private Integer isTouched;

    /**
     * 客户的生日信息
     */
    private String custBirth;

    /**
     * 客户意向度星级
     */
    private Integer star;

    /**
     * 客户意向度得分
     */
    private Integer score;

    /**
     * 客户来源 1:微信好友 2:二度人脉
     */
    private Integer custOrigin;

    /**
     * 客户行为
     */
    private Integer custAction;

    /**
     * 客户访问次数
     */
    private Long visitCount;

    /**
     * 是否为特别关注客户
     */
    private Integer isSpecialCustomer;



    @Data
    public static class CustBirth implements Serializable {
        private static final long serialVersionUID = -8531348343166249037L;
        private Integer isSolarBirthDay;
        private String custBirthDay;
    }




    /**
     * 将用户行为类型 转为存储到数据库中的int类型数据
     *
     * @param oldVal
     * @param actionType
     * @return
     */
    public Integer getIntByActionType(Integer oldVal, Integer actionType) {
        if (Objects.isNull(oldVal) || Objects.isNull(actionType)) {
            return null;
        }
        if(Objects.equals(oldVal,-1)){
            //init
            oldVal=0;
        }
        String binaryStr = CusActionConvertorUtil.getBinaryString(oldVal);
        VisitListTypeEnum typeEnum = VisitListTypeEnum.getByCode(actionType);
        switch (typeEnum) {
            case MATERIAL:
                //填写资料
                return CusActionConvertorUtil.getNewActionTypeInteger(actionType, binaryStr);
            case LOTTERY:
                //中奖
                return CusActionConvertorUtil.getNewActionTypeInteger(actionType, binaryStr);
            case FORWARD:
                //转发
                return CusActionConvertorUtil.getNewActionTypeInteger(actionType, binaryStr);
            case QUESTION:
                //答题
                return CusActionConvertorUtil.getNewActionTypeInteger(actionType, binaryStr);
            case VOTE:
                //投票
                return CusActionConvertorUtil.getNewActionTypeInteger(actionType, binaryStr);
            default:
                //默认返回 null
                return null;
        }

    }

}
