package cn.com.duiba.kjy.api.dto.greeting;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 代理人贺卡分享表
 * @author kjj mybatis generator
 * 2020-03-25
 */
@Data
public class ContentGreetingCardBannerDto implements Serializable {

    private static final long serialVersionUID = 15851230319149984L;

    /**
     * 主键
     */
    private Long id;

    /**
     * banner关联的贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 贺卡标题
     */
    private String bannerTitle;

    /**
     * 贺卡标题
     */
    private String contentTitle;

    /**
     * banner图片地址
     */
    private String imageUrl;

    /**
     * banner背景颜色
     */
    private String backgroundColor;

    /**
     * banner状态 0：未上架 1：已上架
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingBannerStateEnum
     */
    private Integer bannerState;

    /**
     * 角标状态 0：关闭 1：打开
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingBannerCornerStateEnum
     */
    private Integer cornerState;

    /**
     * banner角标图片链接
     */
    private String cornerImageUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
