package cn.com.duiba.kjy.api.remoteservice.serialPay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.serialPayRecord.SerialPayRecordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;
import cn.com.duiba.kjy.api.params.preInstall.SerialPayPageQuery;

import java.util.List;

/**
 * 功能描述：预设会员财务打款审核remote接口类
 *
 * @Auther: xiaotian
 * @Date: 2020/1/3 13:50
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteSerialPayService {

    /**
     * 插入审核记录
     * @param serialPayRecordDto
     * @return
     */
    boolean insert(SerialPayRecordDto serialPayRecordDto);

    /**
     * 更新审核记录
     * @param serialPayRecordDto
     * @return
     */
    boolean update(SerialPayRecordDto serialPayRecordDto);

    /**
     * 筛选列表
     * @param pageQuery
     * @return
     */
    Page<SerialPayRecordDto> queryList(SerialPayPageQuery pageQuery);

    /**
     * 获取详情
     * @param id
     * @return
     */
    SerialPayRecordDto  selectOne(Long id);
}
