package cn.com.duiba.kjy.api.enums.animation;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/16 10:55 AM
 */
public enum AnimationBizTypeEnum {

    GAME_ANIMATION(1001, "热门动画"),
    INVITATION_LETTER_POSTER(1101, "邀请函（海报）"),
    INVITATION_LETTER_ANIMATION(1102, "邀请函（动画）"),
    POSTER(1201, "海报"),
    GREETING_CARD(1301, "贺卡"),
    SELLER_CARD_POSTER(1401, "名片（海报）"),
    HONORARY_ALBUM_POSTER(1501, "荣誉相册（海报）"),
    HONORARY_ALBUM_ANIMATION(1502, "荣誉相册（音乐相册）"),
    ;

    private Integer type;

    private String desc;

    AnimationBizTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, AnimationBizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(AnimationBizTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static AnimationBizTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

    /**
     * 返回bizType是否有效
     * @param bizType 动画工具业务类型
     * @return 是否有效
     */
    public static boolean isActive(Integer bizType) {
        if (bizType == null) {
            return false;
        }
        return getByType(bizType) != null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
