package cn.com.duiba.kjy.api.remoteservice.resourceLocator;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.resourceLocator.ResourceLocatorDto;
import cn.com.duiba.kjy.api.params.resourceLocator.ResourceLocatorPageQueryParam;

import java.util.List;

/**
 * 资源位rpc服务接口
 * @author 吴文哲
 * @date 2020-04-24 11:35
 **/
@AdvancedFeignClient
public interface RemoteResourceLocatorService {

    /**
     * 新增资源位
     * @return
     */
    Long addResourceLocator(ResourceLocatorDto addDto);

    /**
     * 修改资源位
     * @return
     */
    Integer updateResourceLocator(ResourceLocatorDto updateDto);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<ResourceLocatorDto> listByCondition(ResourceLocatorPageQueryParam param);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(ResourceLocatorPageQueryParam param);
}
