package cn.com.duiba.kjy.api.constant;

import cn.com.duiba.kjy.api.util.ErrorCode;

/**
 * Created by zhangshun on 2019/2/1.
 */
public class KjyRuntimeException extends RuntimeException {

    private static final long serialVersionUID = 1369294764194415133L;
    private ErrorCode errorCode;

    public KjyRuntimeException(String message) {
        super(message);
    }

    public KjyRuntimeException(ErrorCode errorCode) {
        super(errorCode.getCode());
        this.errorCode = errorCode;
    }

    public KjyRuntimeException(Throwable cause) {
        super(cause);
    }

    public KjyRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }
}
