package cn.com.duiba.kjy.api.dto.contentinteractionquestion;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 内容互动问题表
 * @author kjj mybatis generator 
 * 2019-07-29
 */
@Data
public class ContentInteractionQuestionDto implements Serializable {
    private static final long serialVersionUID = 15643880805225408L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *内容id
     */
    private Long contentId;

    /**
     *
     *内容类型 0日报 1文章 2下午话题 3晚安心语
     */
    private Byte contentType;

    /**
     *
     *互动类型 0问答题单选 1问答题多选 2投票单选 3投票多选
     */
    private Byte interactionType;

    /**
     *
     *标题
     */
    private String title;

    /**
     *
     *答案说明
     */
    private String instructions;

    /**
     *
     *是否启用配置
     */
    private Byte enableConfig;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;

    /**
     *
     * 一级标题
     */
    private String oneTitle;

    /**
     * 互动来源- 0-文章内配置的互动，1-互动题库，2-销售员模板，3-销售员配置
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionSourceEnum
     */
    private Integer interactionSource;
}