package cn.com.duiba.kjy.api.enums.accurate;

import java.util.stream.Stream;

/**
 * 精准素材列表排序规则枚举
 * @author xiaotian
 * @date 2019-11-14 16:49
 **/

public enum AccurateSortTypeEnum {

    /**
     *  最新
     */
    NEW("new","最新"),

    /**
     * 动画
     */
    HOT("hot","最热"),
    ;


    AccurateSortTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static AccurateSortTypeEnum getByCode(String code){
        return Stream.of(AccurateSortTypeEnum.values()).filter(accurateSortTypeEnum -> accurateSortTypeEnum.getType().equals(code)).findFirst().orElse(null);
    }


}
