package cn.com.duiba.kjy.api.enums.enhanced;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-03-16 16:51
 * @descript 个人栏目FAQ设置枚举
 */
public enum EnhancedColumnQuestionOpenEnum {
    CLOSE(0, "关闭"),
    OPEN(1, "开启"),
    ;

    private Integer code;
    private String description;

    EnhancedColumnQuestionOpenEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据code获取枚举对象
     * @param code
     * @return
     */
    public static EnhancedColumnQuestionOpenEnum getByCode(Integer code) {
        for (EnhancedColumnQuestionOpenEnum openStatus : EnhancedColumnQuestionOpenEnum.values()) {
            if (Objects.equals(openStatus.code, code)) {
                return openStatus;
            }
        }
        return null;
    }
}
