package cn.com.duiba.kjy.api.enums.preInsatll;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum PreInstallTypeEnum {

    LIVE(1, "直播试用账号"),
    INNER(2,"内部员工"),
    SALE_NEW(3,"销售新兵营"),
    COMPANY_OFFLINE(4,"企业线下采购")
    ;

    private Integer code;
    private String desc;

    PreInstallTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, PreInstallTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PreInstallTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static PreInstallTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
