package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;
import cn.com.duiba.kjy.api.dto.UserExtDto;
import cn.com.duiba.kjy.api.dto.user.UserIdOpenIdDto;
import cn.com.duiba.kjy.api.dto.user.UserOpenIdDto;

import java.util.List;

/**
 * Created by dugq on 2019-06-14.
 */
@AdvancedFeignClient
public interface RemoteUserExtService {
    List<UserExtDto> selectByUserId(Long userId);

    UserExtDto selectMpExtByUserId(Long userId);

    UserExtDto selectByUserIdAndOaId(Long userId, Long oaId);

    /**
     * extType = OA 非VIP公众号和用户的关联关系 List
     * extType = VIP VIP公众号和用户的关联关系 List
     * extType = VIP_OA VIP非VIP公众号和用户的关联关系 List
     * @param userId  用户id
     * @param extTypeEnum
     * @return
     */
    List<UserExtDto> selectOaByUserIdAndOaType(Long userId, UserExtTypeEnum extTypeEnum);

    /**
     * extType = OA   where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP  where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP_OA 优先VIP，VIP为空，返回OA
     * @param userId
     * @param extTypeEnum
     * @return
     */
    UserExtDto selectUsingOaByUserIdAndOaType(Long userId, UserExtTypeEnum extTypeEnum);

    /**
     * extType = OA   where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP  where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP_OA 优先VIP，VIP为空，返回OA
     * @param userIds
     * @param extType
     * @return
     */
    List<UserExtDto> findUsingExtByUserIdsAndType(List<Long> userIds, UserExtTypeEnum extType);

    /**
     * 根据openId，查询扩展信息
     * @param openId 用户的标识，对当前公众号唯一
     * @return 扩展信息
     */
    UserExtDto findByOpenId(String openId);

    /**
     * 根据id主键更新 ext信息
     * @param dto
     * @return
     */
    Integer updateWxExt(UserExtDto dto);

    /**
     * 批量查询openId
     * @param userIds 用户ID集合
     * @param extType 类型
     * @see cn.com.duiba.kjy.api.constant.UserExtTypeEnum
     * @return 用户openId
     */
    List<UserOpenIdDto> findOpenIdByIds(List<Long> userIds, String extType);

    /**
     * 根据open ID查询
     * @param openIds
     * @return
     */
    List<UserIdOpenIdDto> selectIdByOpenIds(List<String> openIds);

    /**
     * 批量新增
     * @param usersExtDtoList
     * @return
     */
    Integer batchInsert(List<UserExtDto> usersExtDtoList);
}
