package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityCustomPrizeDto;

/**
 * 自定义奖品配置相关
 * @author lizhi
 * @date 2019/10/28 4:06 PM
 */
@AdvancedFeignClient
public interface RemoteActivityCustomPrizeService {

    /**
     * 根据活动ID、销售员ID，查询最近的一次奖品配置
     * @param activityId 活动ID
     * @param sellerId 销售员ID
     * @return 最近的一次奖品配置
     */
    ActivityCustomPrizeDto findLastCustomPrize(Long activityId, Long sellerId);
}
